<?php
require_once '../config.php';
verificarLogin();

$titulo = "Editar Servidor";
$security = new Security($pdo);

// Buscar servidor DO USUÁRIO ATUAL
$id = $_GET['id'];
$stmt = $pdo->prepare("SELECT * FROM servidores WHERE id = ? AND usuario_id = ?");
$stmt->execute([$id, $_SESSION['usuario_id']]);
$servidor = $stmt->fetch();

if (!$servidor) {
    header("Location: servidores.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Verificar CSRF
    if (!$security->verifyCSRFToken($_POST['csrf_token'])) {
        die("Token CSRF inválido!");
    }
    
    $nome = $security->cleanInput($_POST['nome']);
    $tipo = $security->cleanInput($_POST['tipo']);
    $url = $security->cleanInput($_POST['url']);
    $status = $security->cleanInput($_POST['status']);
    
    try {
        $stmt = $pdo->prepare("UPDATE servidores SET nome = ?, tipo = ?, url = ?, status = ? WHERE id = ? AND usuario_id = ?");
        $stmt->execute([$nome, $tipo, $url, $status, $id, $_SESSION['usuario_id']]);
        
        // Registrar na auditoria
        $stmt = $pdo->prepare("INSERT INTO security_logs (usuario_id, acao, ip_address, user_agent) VALUES (?, ?, ?, ?)");
        $stmt->execute([$_SESSION['usuario_id'], 'editar_servidor', $_SERVER['REMOTE_ADDR'], $_SERVER['HTTP_USER_AGENT']]);
        
        header("Location: servidores.php?sucesso=1");
        exit();
    } catch (PDOException $e) {
        $erro = "Erro ao atualizar servidor: " . $e->getMessage();
    }
}

$csrf_token = $security->generateCSRFToken();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $titulo; ?> - Gestor DREEYTV</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        :root {
            --primary: #667eea;
            --secondary: #2d3748;
            --danger: #f56565;
        }
        
        body {
            background: #f5f7fa;
            color: #2d3748;
        }
        
        .admin-container {
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 280px;
            background: var(--secondary);
            color: white;
        }
        
        .sidebar-header {
            padding: 30px 25px;
            background: rgba(0,0,0,0.2);
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .sidebar-header h2 {
            font-size: 1.5rem;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .sidebar-menu {
            list-style: none;
            padding: 20px 0;
        }
        
        .sidebar-menu li {
            margin: 5px 15px;
        }
        
        .sidebar-menu a {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 15px 20px;
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            border-radius: 10px;
            transition: all 0.3s;
        }
        
        .sidebar-menu a:hover {
            background: rgba(255,255,255,0.1);
            color: white;
        }
        
        .sidebar-menu a.active {
            background: var(--primary);
            color: white;
        }
        
        .main-content {
            flex: 1;
            padding: 30px;
        }
        
        .header {
            background: white;
            padding: 25px 30px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            margin-bottom: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .header h1 {
            font-size: 1.8rem;
            background: linear-gradient(135deg, var(--primary), #5a6fd8);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .user-avatar {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary), #5a6fd8);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
        }
        
        .content {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            max-width: 600px;
            margin: 0 auto;
        }
        
        .form-header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .form-header .icon {
            font-size: 3rem;
            margin-bottom: 10px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #2d3748;
        }
        
        .form-control {
            width: 100%;
            padding: 15px;
            border: 2px solid #e2e8f0;
            border-radius: 10px;
            font-size: 16px;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: var(--primary);
            outline: none;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 15px 25px;
            background: var(--primary);
            color: white;
            text-decoration: none;
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
            font-size: 16px;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
        }
        
        .btn-block {
            display: block;
            width: 100%;
        }
        
        .btn-danger {
            background: var(--danger);
        }
        
        .btn-danger:hover {
            box-shadow: 0 5px 15px rgba(245, 101, 101, 0.3);
        }
        
        .form-actions {
            display: flex;
            gap: 15px;
            margin-top: 30px;
        }
        
        .alert {
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        
        .alert-danger {
            background: #fed7d7;
            color: #742a2a;
            border: 1px solid #feb2b2;
        }
        
        @media (max-width: 768px) {
            .admin-container {
                flex-direction: column;
            }
            
            .sidebar {
                width: 100%;
            }
            
            .form-actions {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <div class="admin-container">
        <div class="sidebar">
            <div class="sidebar-header">
                <h2>📺 GESTOR DREEYTV</h2>
            </div>
            <ul class="sidebar-menu">
                <li><a href="../index.php">📊 Dashboard</a></li>
                <li><a href="../clientes/clientes.php">👨‍💼 Clientes</a></li>
                <li><a href="../planos/planos.php">📋 Planos</a></li>
                <li><a href="servidores.php">🖥️ Servidores</a></li>
                <?php if ($_SESSION['usuario_tipo'] == 'admin'): ?>
                    <li><a href="../usuarios/usuarios.php">👥 Usuários</a></li>
                <?php endif; ?>
                <li><a href="../senha/alterar_senha.php">🔑 Alterar Senha</a></li>
                <li><a href="../logout.php">🚪 Sair</a></li>
            </ul>
        </div>
        
        <div class="main-content">
            <div class="header">
                <h1>Editar Servidor</h1>
                <div class="user-info">
                    <div class="user-avatar"><?php echo substr($_SESSION['usuario_nome'], 0, 1); ?></div>
                    <div>
                        <div style="font-weight: 600;"><?php echo $_SESSION['usuario_nome']; ?></div>
                        <div style="font-size: 0.9rem; color: #666;"><?php echo ucfirst($_SESSION['usuario_tipo']); ?></div>
                    </div>
                    <a href="../logout.php" class="btn" style="background: var(--danger);">🚪 Sair</a>
                </div>
            </div>
            
            <div class="content">
                <div class="form-header">
                    <div class="icon">✏️</div>
                    <h2>Editar Servidor</h2>
                    <p style="color: #666;">Atualize as informações do servidor</p>
                </div>
                
                <?php if (isset($erro)): ?>
                    <div class="alert alert-danger">
                        <strong>❌ Erro:</strong> <?php echo $erro; ?>
                    </div>
                <?php endif; ?>
                
                <form method="POST">
                    <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                    
                    <div class="form-group">
                        <label class="form-label" for="nome">🏷️ Nome do Servidor</label>
                        <input type="text" id="nome" name="nome" class="form-control" value="<?php echo htmlspecialchars($servidor['nome']); ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="tipo">🎯 Tipo de Servidor</label>
                        <select id="tipo" name="tipo" class="form-control" required>
                            <option value="HD" <?php echo $servidor['tipo'] == 'HD' ? 'selected' : ''; ?>>HD</option>
                            <option value="FHD" <?php echo $servidor['tipo'] == 'FHD' ? 'selected' : ''; ?>>Full HD</option>
                            <option value="4K" <?php echo $servidor['tipo'] == '4K' ? 'selected' : ''; ?>>4K</option>
                            <option value="8K" <?php echo $servidor['tipo'] == '8K' ? 'selected' : ''; ?>>8K</option>
                            <option value="VIP" <?php echo $servidor['tipo'] == 'VIP' ? 'selected' : ''; ?>>VIP</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="url">🔗 URL do Servidor</label>
                        <input type="url" id="url" name="url" class="form-control" value="<?php echo htmlspecialchars($servidor['url']); ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="status">🔍 Status</label>
                        <select id="status" name="status" class="form-control" required>
                            <option value="ativo" <?php echo $servidor['status'] == 'ativo' ? 'selected' : ''; ?>>✅ Ativo</option>
                            <option value="inativo" <?php echo $servidor['status'] == 'inativo' ? 'selected' : ''; ?>>❌ Inativo</option>
                        </select>
                    </div>
                    
                    <div class="form-actions">
                        <button type="submit" class="btn btn-block">💾 Atualizar Servidor</button>
                        <a href="servidores.php" class="btn btn-danger btn-block">❌ Cancelar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</body>
</html>